;
; Character drawing, scrolling,
; and alpha cursor routines.
;
; Entries :
;		dchar - draw character.
;		acursr - update alpha cursor (erase or draw
;			 as needed).
;		dacurs - draw alpha cursor at acx, acy.
;		racurs - erase alpha cursor at acx, acy.
;
;
; Draw character at alpha cursor position.  Move alpha cap to
; next char position. Moves gfx cap as well unless caps are 
; unlinked (via sap cmd).   Note - if overlay plane is selected
; for writing and lf is done at bottom of screen, the overlay
; plane is scrolled up one char line.  


echar:	php
	rep	#0x20

$1:	bit	Dpdone-1
	bvc	$1
	lda	<xpos
	sta	Xcap
	sec
	lda	<ypos
	sbc	<fudge
	sta	Ycap

	lda	<cwidth
	dec	a
	sta	0xfe00
	lda	<chight
	dec	a
	sta	0xfe02
	sep	#0x20
	lda	<bcolor
	sta	DaColr
	sta	DaFrr
	plp
	rts

dchar:
	php
	rep	#0x30
	pha
	phx
	phy

	bit	<acflag-1	; alpha/graphics caps linked ?
	bvc	$linked		; br if yes.
	pei	<xpos		; no, save graphics cap.
	pei	<ypos
	ldx	<acx		; move to alpha cap.
	stx	<xpos
	ldx	<acy
	stx	<ypos
$linked:
	sep	#0x30
	and	#127
	sta	<ctemp1
	cmp	#32
	bne	$rub
	brl	$all		; check destructo for space.
$rub	cmp	#127
	bne	$0
	brl	$del
$0:
	sec
	sbc	#33
	bcs	$1
	brl	$ctlchr		; do control char.
$1:
;
; Calculate char definition -
; (character-0x21 (in acc)) * csy (*2 more if csx > 8);
;
	rep	#0x20
	and	##0xff
	inc	a
	ldx	<csx
	cpx	#9
	bcc	$w1
	asl	a
$w1:	bit	Dpdone-1
	bvc	$w1
	sta	0xfe00		; multiplicand.
	lda	<csy
	and	##0x1f
	sta	0xfe04		; multiplier.
	sta	DaMul		; multiply.
$w2:	bit	Dpdone-1	; wait for result.
	bvc	$w2
	lda	0xfe02		; get product.
	and	##0xfff		; mask off sign nibble.
	dec	a
	cpx	#9
	bcc	$w3
	dec	a
$w3:
	sta	<ctemp		; save char index into font.
$all:

;
; erase char box if destructo option set.
;
	sep	#0x20
	bit	<chropt
	bpl	$noers
	bsl	echar
$noers:
	lda	<ctemp1
	cmp	#32
	bne	$noer1
	brl	$space
$noer1:
	rep	#0x10
	ldx	<ypos

	lda	<ctemp1
	cmp	#'_'
	beq	$desc
	cmp	#';'
	beq	$desc
	cmp	#'g'
	beq	$desc
	cmp	#'j'
	beq	$desc
	cmp	#'p'
	beq	$desc
	cmp	#'q'
	beq	$desc
	cmp	#'y'
	bne	$nodesc
$desc:
	rep	#0x20
	sec
	txa
	sbc	<desc
	tax
	sep	#0x20
$nodesc:
	bit	Dpdone			; wait for dpu.
	bvc	$nodesc

	stx	Ycap
	ldx	<xpos
	stx	Xcap
	ldy	<ctemp
	lda	<color			; restore foreground color.
	sta	DaColr

	lda	<csy
	sta	<ctemp
	stz	<ctemp+1
	lda	<csx
	cmp	#9
	bcc	$small

	rep	#0x30
	ldx	<ctemp

$ll:	lda	[<fntptr],y	; get char row mask.

	sta	0xfe30
	dey
	dey
	dex
	bne	$ll		; br if no.
	bra	$space
;
; here for fonts with 8 or less bits/row.
;

$small:	
	rep	#0x30
	ldx	<ctemp
$sm:	lda	[<fntptr],y
	asl	a
	asl	a
	asl	a
	asl	a
	sta	0xfe30
	dey
	dex
	bne	$sm
;	bra	$space
			
$space:
	rep	#0x30
	clc
	lda	<xpos
	adc	<cwidth
	sta	<xpos

	clc
	adc	<cwidth
	cmp	<rgtmar
	bcc	$done		; br if next char won't be > rgtmar
	beq	$done
	lda	<lftmar
	sta	<xpos
	bra	$lf
$done
	sep	#0x20
	lda	<color
$done1:	bit	Dpdone
	bvc	$done1
	sta	DaColr	

	rep	#0x30
	bit	<acflag-1	; caps linked ?
	bvc	$done2		; done if yes.
	lda	<xpos		; no, preserve alpha position
	sta	<acx		; and restore graphics cap.
	lda	<ypos
	sta	<acy
	pla
	sta	<ypos
	pla	
	sta	<xpos
$done2:
	ply
	plx
	pla
	plp
	rtl

$ctlchr:
	sep	#0x20
	lda	<ctemp1
	cmp	#' '
	beq	$space
	cmp	#13		; cr
	beq	$cr
	cmp	#10		; lf
	beq	$lf
	cmp	#9		; tab
	beq	$space
	cmp	#12		; form feed
	beq	$ffd
	cmp	#8		; back space
	bne	$ct1	
	brl	$bs
$ct1	cmp	#7		; bel
	bne	$ct2
	brl	$bel
$ct2	brl	$done

$cr:
	rep	#0x20
	lda	<lftmar
	sta	<xpos
	brl	$done
$lf:
	rep	#0x20
	sec
	lda	<ypos
	sbc	<chight
	bmi	$scroll
	cmp	<botmar
	bcc	$scroll
	sta	<ypos
	brl	$done
$scroll:
	lda	Capctl
	bit	##0x20		; writing overlay plane ?
	beq	$hom		; br if no, home cursor.
	lda	<lftmar
	sta	<xpos
	bsl	scroll
	brl	$done
$ffd:
	jsl	>0,Erase
$hom:
	rep	#0x20
	lda	<lftmar
	sta	<xpos

	lda	<topmar
	sec
	sbc	<chight
	sta	<ypos
	brl	$done
$bs:
	rep	#0x20
	sec
	lda	<xpos
	sbc	<cwidth
	bmi	$bs1
	cmp	<lftmar
	bcs	$bs2
$bs1:	lda	<lftmar
$bs2:
	sta	<xpos
	bit	<chropt-1
	bmi	$bs3
	bsl	echar
$bs3:
	brl	$done
$del:
	rep	#0x20
	sec
	lda	<xpos
	sbc	<cwidth
	bmi	$del1
	cmp	<lftmar
	bcs	$del2
$del1:	lda	<lftmar
$del2:
	sta	<xpos
	bsl	echar
	brl	$done

$bel:
	lda	#2
	tsb	Beeper
	brl	$done

;
; Local routine to scroll screen
; upwards.  The commented code
; is for the original cpu boards.
; 

scroll:
	php
	rep	#0x30

	ldy	##-4

	clc
	lda	<chight
	adc	##3
	and	##0xffff-3
	sta	<ctemp
	
$1:	bit	Dpdone-1	; wait dpu
	bvc	$1

	sta	0xfe02		; dist from source to target.
	stz	Rbx
	sec
	lda	##1024
	sbc	<ctemp
	sta	Rby		; set y cap.

	sta	<ctemp1		;;; calc line group count.
	lsr	<ctemp1
	lsr	<ctemp1
	lda	<ctemp1

	sta	0xfe00		; # lines to scroll.
	sty	0xfe04		; offset from last line to next.

	lda	##7
	trb	Capctl

	sta	DaScr		; scroll.
;
; erase bottom <ctemp lines of screen
;
$30:	bit	Dpdone-1
	bvc	$30
	stz	Rbx
	stz	Rby
	
	lda	##0x500
	sta	0xfe00

	clc
	lda	<ypos
	adc	<chight
	sec
	sbc	<fudge
	
	sta	0xfe02
	stz	DaColr
	sta	DaFrr

	lda	<color
	and	##0xff
$31:	bit	Dpdone-1
	bvc	$31
	sta	DaColr
	plp
	rts

dchend:


;
; Alpha cursor routines.
;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Draw or erase cursor if it's time.	;
; Called from idle loops in alpha mode. ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

acursr:
	php
	rep	#0x20

	lda	<actime		; get time to toggle cursor.
	cmp	Vcount		; time yet ?
	bcs	$done		; done if no.
	bit	<acflag-1
	bpl	$2
	plp
	brl	racurs
$2:	plp
	brl	dacurs
$done:
	plp
	rts


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Draw alpha cursor, unless	;
; alpha cursor color is 0.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

dacurs:
	php
	rep	#0x30
	phx
	phy

	sep	#0x30
	lda	<acolor
	beq	$done
	bsl	csetup		; set up to draw cursor.
	lda	#128
	tsb	<acflag		; set alpha cursor drawn flag.
	ldx	<acolor		; alpha cursor color.
$l1:
	lda	Vm
	sta	(<acbuf),y
	stx	Vmimaj
	dey
	cpy	<ctemp
	bne	$l1

	rep	#0x20
	lda	<ctemp1
	sta	Xcap
	sep	#0x20
	bit	Vmimin
$l2:
	lda	Vm
	sta	(<acbuf),y
	stx	Vmimaj
	dey
	bne	$l2

	rep	#0x30
	clc
	lda	Vcount
	adc	##45
	sta	<actime
$done
	rep	#0x30
	ply
	plx
	plp
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;
; Remove alpha cursor.	;
;;;;;;;;;;;;;;;;;;;;;;;;;

racurs:
	php
	rep	#0x30
	pha
	phx
	phy

	sep	#0x30
	bit	<acflag
	bpl	$done
	lda	#128
	trb	<acflag

	bsl	csetup

$1:	lda	(<acbuf),y
	sta	Vmimaj
	dey
	cpy	<ctemp
	bne	$1

	rep	#0x20
	clc
	lda	<actime
	adc	##15
	sta	<actime

	lda	<ctemp1
	sta	Xcap
	sep	#0x20
	bit	Vmimin
$2:
	lda	(<acbuf),y
	sta	Vmimaj
	dey
	bne	$2

$done:
	rep	#0x30
	ply
	plx
	pla
	plp
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Local routine to set up for	;
; drawing or erasing alf cursor.;
; Returns with total number of	;
; pixels in cursor in y, length	;
; of cursor in <ctemp, sets cap	;
; and cap control reg.  Sets	;
; temp1 to x coord of cursor.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

csetup:
	php
	rep	#0x30

	bit	<acflag-1	; caps linked ?
	bvs	$1		; br if no.

	ldy	<ypos		; yes, alpha position is
	ldx	<xpos		; at graphics cap.
	bra	$2
$1:
	ldy	<acy		; no, get saved alpha cap.
	ldx	<acx
$2:
	stx	<ctemp1
	dey
	dey
$3:	bit	Dpdone-1
	bvc	$3
	stx	Xcap
	sty	Ycap
	
	sep	#0x30
	lda	#7
	trb	Capctl		; x major, both up.

	lda	<csx		; single wide cursor length.
	bit	<chrsiz		; doing double size ?
	bvc	$4		; br if no.
	asl	a		; yes, double the length.
$4:	sta	<ctemp		; save length.
	asl	a		; get total # pixels to do.
	tay

	plp
	rts

	end
